// משתנים גלובליים
let pendingNewMessagesNodes = [];
const POLLING_INTERVAL = 10000; // בדיקה כל 10 שניות
let originalTitle = document.title; // שמירת הכותרת המקורית

// 1. יצירת הכפתור והוספתו לדף
const btn = document.createElement('div');
btn.id = 'prog-updater-btn';
btn.style.display = 'none';
document.body.appendChild(btn);

// 2. פונקציית הבדיקה
async function checkForUpdates() {
    // זיהוי ההודעות בדף הנוכחי
    const currentMessages = document.querySelectorAll('article.js-post');
    if (currentMessages.length === 0) return;

    // שליפת ה-ID האחרון שקיים כרגע בדף (לצורך סינון ראשוני)
    const lastMsg = currentMessages[currentMessages.length - 1];
    const lastIdAttr = lastMsg.getAttribute('data-content');
    
    if (!lastIdAttr) return;
    
    const lastId = parseInt(lastIdAttr.split('-')[1]);
    
    // כתובת ללא Cache
    const urlWithNoCache = window.location.href + (window.location.href.includes('?') ? '&' : '?') + 't=' + Date.now();

    try {
        const response = await fetch(urlWithNoCache);
        const html = await response.text();
        const parser = new DOMParser();
        const doc = parser.parseFromString(html, 'text/html');
        
        const fetchedMessages = doc.querySelectorAll('article.js-post');
        
        // סינון הודעות חדשות
        const newItems = [];
        fetchedMessages.forEach(msg => {
            const attr = msg.getAttribute('data-content');
            if (attr) {
                const msgId = parseInt(attr.split('-')[1]);
                
                // תיקון קריטי:
                // 1. בודקים שה-ID גדול מהאחרון שהיה ידוע
                // 2. בודקים שההודעה לא קיימת כבר בדף (מונע כפילות בהודעות שלך או אם הדף התעדכן לבד)
                const alreadyOnPage = document.querySelector(`article[data-content="${attr}"]`);
                
                if (msgId > lastId && !alreadyOnPage) {
                    newItems.push(msg);
                }
            }
        });

        // עדכון ממשק המשתמש
        if (newItems.length > 0) {
            pendingNewMessagesNodes = newItems;
            showButton(newItems.length);
            updateTabTitle(newItems.length); 
        } else {
            // אם אין הודעות חדשות (או שהן כבר הוצגו), נעלים את הכפתור
            // זה מטפל במקרה שבו המשתמש רענן ידנית או שהדף התעדכן לבד
            if (btn.style.display === 'block') {
                btn.style.display = 'none';
                resetTabTitle();
            }
        }

    } catch (error) {
        console.error("שגיאה בבדיקת עדכונים:", error);
    }
}

function updateTabTitle(count) {
    // הסרת סוגריים קודמים אם יש, כדי למנוע (1) (2) הודעות...
    const cleanTitle = document.title.replace(/^\(\d+\)\s/, '').replace("הודעות חדשות! - ", "");
    // אם הכותרת המקורית השתנתה בינתיים (למשל ע"י פרוג עצמו), נעדכן אותה
    if (!cleanTitle.includes("הודעות חדשות!")) {
         originalTitle = cleanTitle.replace(/^\(\d+\)\s/, ''); // ניקוי יסודי
    }
    
    document.title = `(${count}) הודעות חדשות! - ${originalTitle}`;
}

function resetTabTitle() {
    // מחזיר לכותרת נקייה (ללא המספר)
    document.title = document.title.replace(/^\(\d+\)\sהודעות חדשות! - /, '');
}

function showButton(count) {
    btn.innerHTML = `⬇ יש ${count} הודעות חדשות`;
    btn.style.display = 'block';
}


btn.addEventListener('click', () => {
    const container = document.querySelector('.block-body.js-replyNewMessageContainer') || 
                      document.querySelector('.block-body');
    
    if (!container) return;

    pendingNewMessagesNodes.forEach(node => {
        // בדיקה חוזרת לפני הוספה - לוודא שלא נוסף בינתיים
        const attr = node.getAttribute('data-content');
        if (!document.querySelector(`article[data-content="${attr}"]`)) {
            const importedNode = document.importNode(node, true);
            importedNode.classList.add('new-injected-post'); 
            importedNode.classList.add('js-activate-me'); 
            container.appendChild(importedNode);
        }
    });

    activateXenForoScripts();

    const firstNew = document.querySelector('.new-injected-post');
    if (firstNew) {
        firstNew.scrollIntoView({behavior: 'smooth', block: 'center'});
        // הסרת הקלאס לאחר האנימציה
        setTimeout(() => {
            document.querySelectorAll('.new-injected-post').forEach(el => el.classList.remove('new-injected-post'));
        }, 3000);
    }

    // איפוסים
    btn.style.display = 'none';
    pendingNewMessagesNodes = [];
    resetTabTitle(); 
});

function activateXenForoScripts() {
    const script = document.createElement('script');
    script.textContent = `
        try {
            const newItems = document.querySelectorAll('.js-activate-me');
            if (window.XF && window.XF.activate) {
                // הפעלת הסקריפטים של פרוג (ציטוטים, לייקים וכו') על האלמנטים החדשים
                window.XF.activate(newItems);
            }
            newItems.forEach(el => el.classList.remove('js-activate-me'));
        } catch(e) { console.error(e); }
    `;
    (document.head || document.documentElement).appendChild(script);
    script.remove();
}

setInterval(checkForUpdates, POLLING_INTERVAL);